<?php
header('Content-Type: application/json; charset=utf-8');

$role = $_GET['role'] ?? '';
if (!in_array($role, ['rektor', 'yayasan'], true)) {
  http_response_code(400);
  echo json_encode(['ok' => false, 'msg' => 'invalid role']); exit;
}

$dir = __DIR__ . '/../data';
if (!is_dir($dir)) mkdir($dir, 0775, true);

$streamFile = $dir . "/stream_{$role}.ndjson";
$stateFile  = $dir . "/state_{$role}.json";

if (file_exists($streamFile)) unlink($streamFile);

file_put_contents($stateFile, json_encode(['seq'=>0,'done'=>false,'updated'=>time()], JSON_PRETTY_PRINT));

echo json_encode(['ok'=>true]);