<?php
header('Content-Type: application/json; charset=utf-8');

$role = $_GET['role'] ?? '';
if (!in_array($role, ['rektor', 'yayasan'], true)) {
  http_response_code(400);
  echo json_encode(['ok' => false, 'msg' => 'invalid role']); exit;
}

$raw = file_get_contents('php://input');
if (!$raw) {
  http_response_code(400);
  echo json_encode(['ok' => false, 'msg' => 'empty body']); exit;
}

$data = json_decode($raw, true);
if (!is_array($data) || !isset($data['type'])) {
  http_response_code(400);
  echo json_encode(['ok' => false, 'msg' => 'invalid json']); exit;
}

$dir = __DIR__ . '/../data';
if (!is_dir($dir)) mkdir($dir, 0775, true);

$streamFile = $dir . "/stream_{$role}.ndjson";
$stateFile  = $dir . "/state_{$role}.json";

if (!file_exists($stateFile)) {
  file_put_contents($stateFile, json_encode(['seq'=>0,'done'=>false,'updated'=>time()], JSON_PRETTY_PRINT));
}

$state = json_decode(file_get_contents($stateFile), true);
if (!is_array($state)) $state = ['seq'=>0,'done'=>false,'updated'=>time()];

$seq = intval($state['seq'] ?? 0) + 1;

$payload = [
  'seq'  => $seq,
  't'    => time(),
  'type' => $data['type'],
  'p'    => $data['p'] ?? null
];

$line = json_encode($payload) . "\n";

$fp = fopen($streamFile, 'a');
if ($fp) {
  flock($fp, LOCK_EX);
  fwrite($fp, $line);
  fflush($fp);
  flock($fp, LOCK_UN);
  fclose($fp);
}

$state['seq'] = $seq;
$state['done'] = false;
$state['updated'] = time();
file_put_contents($stateFile, json_encode($state, JSON_PRETTY_PRINT));

echo json_encode(['ok'=>true,'seq'=>$seq]);